#include "maindefs.h"
#include "pin_interrupts.h"
#include "pwm.h"
#include "msg_queues.h"
#include <delays.h>

unsigned char port_b_prev_state;

void intx_init() {
    TRISAbits.TRISA5 = 1;
    
    TRISCbits.TRISC2 = 0;

    RPINR1 = 2; // Bind INT1 interrupt to RP2

    INTCON2bits.INTEDG1 = 0;    // Trigger on falling edge
}

void int1_interrupt_handler() {
    MQ_sendmsg_ToMainFromLow(0, MSGTYPE_INT1, (void *) 0);
}

void port_b_int_init() {
    port_b_prev_state = 0x0F;

    INTCON2bits.RBPU = 0;
    
    // Set pins as inputs
    TRISBbits.TRISB4 = 1;
    TRISBbits.TRISB5 = 1;
    TRISBbits.TRISB6 = 1;
    TRISBbits.TRISB7 = 1;

    // Turn on internal voltage pull-up?
    PORTBbits.RB4 = 1;
    PORTBbits.RB5 = 1;
    PORTBbits.RB6 = 1;
    PORTBbits.RB7 = 1;
    LATBbits.LATB4 = 1;
    LATBbits.LATB5 = 1;
    LATBbits.LATB6 = 1;
    LATBbits.LATB7 = 1;
}

void port_b_int_interrupt_handler() {
    // Pull the new pin values
    unsigned char new_state = (PORTB & 0xF0) >> 4;

    // Query which pin input value changed and send value to main()
    if ((new_state ^ port_b_prev_state) & 0x01) {
        if (port_b_prev_state & 0x01) {
            // Pin transitioned HIGH -> LOW (button pressed)
            DBG_PRINT_PORTB_INT("Port B4 HIGH->LOW\r\n");
            MQ_sendmsg_ToMainFromLow(0, MSGTYPE_PORTB_4_DOWN, (void *) 0);
        } else {
            // Pin transitioned LOW -> HIGH (button released)
            DBG_PRINT_PORTB_INT("Port B4 LOW->HIGH\r\n");
            MQ_sendmsg_ToMainFromLow(0, MSGTYPE_PORTB_4_UP, (void *) 0);
        }
    }
    if ((new_state ^ port_b_prev_state) & 0x02) {
        if (port_b_prev_state & 0x02) {
            // Pin transitioned HIGH -> LOW (button pressed)
            DBG_PRINT_PORTB_INT("Port B5 HIGH->LOW\r\n");
            MQ_sendmsg_ToMainFromLow(0, MSGTYPE_PORTB_5_DOWN, (void *) 0);
        } else {
            // Pin transitioned LOW -> HIGH (button released)
            DBG_PRINT_PORTB_INT("Port B5 LOW->HIGH\r\n");
            MQ_sendmsg_ToMainFromLow(0, MSGTYPE_PORTB_5_UP, (void *) 0);
        }
    }
    if ((new_state ^ port_b_prev_state) & 0x04) {
        if (port_b_prev_state & 0x04) {
            // Pin transitioned HIGH -> LOW (button pressed)
            DBG_PRINT_PORTB_INT("Port B6 HIGH->LOW\r\n");
            MQ_sendmsg_ToMainFromLow(0, MSGTYPE_PORTB_6_DOWN, (void *) 0);
        } else {
            // Pin transitioned LOW -> HIGH (button released)
            DBG_PRINT_PORTB_INT("Port B6 LOW->HIGH\r\n");
            MQ_sendmsg_ToMainFromLow(0, MSGTYPE_PORTB_6_UP, (void *) 0);
        }
    }
    if ((new_state ^ port_b_prev_state) & 0x08) {
        if (port_b_prev_state & 0x08) {
            // Pin transitioned HIGH -> LOW (button pressed)
            DBG_PRINT_PORTB_INT("Port B7 HIGH->LOW\r\n");
            MQ_sendmsg_ToMainFromLow(0, MSGTYPE_PORTB_7_DOWN, (void *) 0);
        } else {
            // Pin transitioned LOW -> HIGH (button released)
            DBG_PRINT_PORTB_INT("Port B7 LOW->HIGH\r\n");
            MQ_sendmsg_ToMainFromLow(0, MSGTYPE_PORTB_7_UP, (void *) 0);
        }
    }
    
    // Save the new state of pins
    port_b_prev_state = new_state;
}
